


 /**
 ******************************************************************************
 *
 * @file        MCU.c
 * @brief       The mcu Code's c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/11/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_PW_DRV.h"
#include "MG32_USBD_API.h"
#include "MG32_USBD_EasyCOM_API.h"
#include "MG32_USBD_EasyHID_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/  
extern void ChipInit(void);
 
/* External variables --------------------------------------------------------*/ 
 
 
/**
 *******************************************************************************
 * @brief	    MCU initial.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void MCU_Init(void)
{
    //========================================
    //CSC & GPIO Initial
    ChipInit();
    
    //=======================================
    //COM Parameter Initial.
    API_COM_Init();
    
    //=======================================
    //Easy HID Parameter Initial.
    API_HID_Init();
    
    //=======================================
    //USB Initial
    
    //---------------------------------------
    //USB Power Control Related
    UnProtectModuleReg(PWprotect);
    PW_PeriphSLEEPModeContinuous_Config(PW_SLPPO_USB,ENABLE);
    PW_PeriphSTOPModeWakeUp_Config( PW_WKSTP_USB , ENABLE);
    ProtectModuleReg(PWprotect);
    //---------------------------------------
    //USB Initial
    API_USBD_Init();


    
}
 







